import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;

public class PressureAvgView1 extends JPanel {
	private PressureAvgController1 c;
	
	public PressureAvgView1( PressureAvgController1 pac ) {
		c= pac;
		setBackground(Color.BLUE);
		setPreferredSize(new Dimension(400,400));
	}
	
	public void paintComponent( Graphics g ) {
		super.paintComponent( g );
		Graphics2D g2= (Graphics2D) g;
		double x= 150;
		double height= ((double) c.getPressure()/1000.0) * 300;
		double width= 10;
		double y= 300 - height;

		Rectangle2D.Double rect= new Rectangle2D.Double( x, y, width, height );
		g2.setPaint( Color.red );
		g2.fill( rect );
		g2.setPaint( Color.white );
		g2.drawString("Average pressure = " + c.getAveragePressure(), 70, 350 );
	}
}